;	-----------------------------------------
;	FREQUENZ, Modul fr CPP9201
;	-----------------------------------------
; erzeugt aus den Zhlwerten fz0 bis fz3 dezimale Ziffern
; Ausgang: r9 bis r15, je 1 Ziffer in 1 byte

frequenz:
	sbrs	merker1,torende
	ret
	cbr		merker1,(1<<torende)
; Frequenzdaten in 3 Byte schieben > fz1,fz2,tfz3
	rol		fz2
	rol		fz1
	rol		fz0
	rol		fz2
	rol		fz1
	rol		fz0
	rol		fz2
	rol		fz1
	rol		fz0
	andi	fz2,0b11111000
	clr		acc
	bst		fz3,3
	bld		acc,0
	bst		fz3,2
	bld		acc,1
	bst		fz3,1
	bld		acc,2
	or		fz2,acc
	andi	fz0,0b00111111
	
; Frequenzdaten sichern fr die AVR
	sts		istfrequenz,fz0
	sts		istfrequenz+1,fz1
	sts		istfrequenz+2,fz2
; welche ZF? Frequ-Grenze abziehen =  4,9MHz, (7 7A 10H)
	cpi		fz2,0			; Carry lschen
	sbci	fz2,0x10
	sbci	fz1,0x7a
	sbci	fz0,7
	brcc	frequ1			; hohe ZF?
; niedrige ZF, 4,9MHz-454kHz=444600 (6 C8 B8H) wieder addieren
	ldi		acc,0xba
	add		fz2,acc
	ldi		acc,0xc8
	adc		fz1,acc
	ldi		acc,6
	adc		fz0,acc
	jmp		frequ2
; Hohe ZF, 4,9MHz-2,546MHz=235400 (3 97 88H) wieder addieren
frequ1:
	ldi		acc,0x86 
	add		fz2,acc
	ldi		acc,0x97
	adc		fz1,acc
	ldi		acc,3
	adc		fz0,acc
; die eltzte Ziffer (10Hz-Auflsung) wird nur fr die AFC
; bentigt, aber nicht mehr angezeigt. Deshalb mu der
; Messwert fr die Anzeige durch 10 dividiert werden.
frequ2:
	mov		var12,fz0		; max. = 33 E1 40 H
	mov		var11,fz1
	mov		var10,fz2
	clr		var22
	clr		var21
	ldi		var20,10
	call	div24u
	mov		fz0,var12		; max = 5 30 20 H
	mov		fz1,var11
	mov		fz2,var10
	call	beruhigen
; nach BCD wandeln R9(HW)...R15(NW)
; 1.) das (hchste) 5.nibble = 65536 (1 00 00H)
	clr		r9
	clr		r10
	clr		r11
	clr		r12
	clr		r13
	clr		r14
	clr		r15
	ldi		zl,low((nible5<<1)+7)
	ldi		zh,high((nible5<<1)+7)
	mov		acc,fz0
	call	bin22dez6
; 2.) das 4.nible nach Dezimalziffer
	ldi		zl,low((nible4<<1)+7)
	ldi		zh,high((nible4<<1)+7)
	mov		acc,fz1
	swap	acc
	call	bin22dez6
; 3.) das 3.nible nach Dezimalziffer
	ldi		zl,low((nible3<<1)+7)
	ldi		zh,high((nible3<<1)+7)
	mov		acc,fz1
	call	bin22dez6
; 4.) das 2.nible nach Dezimalziffer
	ldi		zl,low((nible2<<1)+7)
	ldi		zh,high((nible2<<1)+7)
	mov		acc,fz2
	swap	acc
	call	bin22dez6
; 5.) das 1.nible nach Dezimalziffer
	ldi		zl,low((nible1<<1)+7)
	ldi		zh,high((nible1<<1)+7)
	mov		acc,fz2
	call	bin22dez6
; in 7-Segmente wandeln
	call	dezsegmente
	call	avr
	ret
	
; ------------------------------------------
; BIN22DEZ6
; ------------------------------------------

bin22dez6:		
	andi	acc,0x0f
	lsl		acc
	lsl		acc
	lsl		acc
	add		zl,acc
	clr		acc
	adc		zh,acc

	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r15
	cpi		acc,10
	brcs	bdez1
	subi	acc,10
	inc		r14
bdez1:
	mov		r15,acc
	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r14
	cpi		acc,10
	brcs	bdez2
	subi	acc,10
	inc		r13
bdez2:
	mov		r14,acc
	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r13
	cpi		acc,10
	brcs	bdez3
	subi	acc,10
	inc		r12
bdez3:
	mov		r13,acc
	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r12
	cpi		acc,10
	brcs	bdez4
	subi	acc,10
	inc		r11
bdez4:
	mov		r12,acc
	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r11
	cpi		acc,10
	brcs	bdez5
	subi	acc,10
	inc		r10
bdez5:
	mov		r11,acc
	lpm		acc,z
	sbiw	zh:zl,1
	add		acc,r10
	cpi		acc,10
	brcs	bdez9
	subi	acc,10
	inc		r9
bdez9:
	mov		r10,acc
	ret

; ------------------------------------------
; DEZSEGMENTE
; ------------------------------------------
; in 7-Segment wandeln

dezsegmente:
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r10
	add		zl,r10
	clr		acc
	adc		zh,acc
	lpm		r10,z
	
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r11
	add		zl,r11
	clr		acc
	adc		zh,acc
	lpm		r11,z
	
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r12
	add		zl,r12
	clr		acc
	adc		zh,acc
	lpm		r12,z
	
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r13
	add		zl,r13
	clr		acc
	adc		zh,acc
	lpm		r13,z
	
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r14
	add		zl,r14
	clr		acc
	adc		zh,acc
	lpm		r14,z
	
	ldi		zl,low(segmente<<1)
	ldi		zh,high(segmente<<1)
	add		zl,r15
	add		zl,r15
	clr		acc
	adc		zh,acc
	lpm		r15,z
; Platz fr Dezimalpunkt machen
	mov		r9,r10
	mov		r10,r11
	ldi		acc,0b1000_0000
	mov		r11,acc

	ret

; ------------------------------------------
; BERUHIGUNG
; ------------------------------------------
; vermindert das flattern der letzten Ziffer

beruhigen:
	lds		r26,anzeigezsp  		; HW
	lds		r27,anzeigezsp+1
	lds		r28,anzeigezsp+2
	sub		r26,fz0
	sbc		r27,fz1
	sbc		r28,fz2
	mov		acc,r26
	or		acc,r27
	or		acc,r28
	brne	ber1				; nicht null!
	cbr		merker1,(minus<<1)
	cbr		merker1,(plus<<1) 	; ist identisch
	jmp		ber3				
ber1:
	cpi		r28,1  				; ergebnis = +1?
	brne	ber2
	mov		acc,r27
	or		acc,r26
	brne	ber2
	sbr		merker1,(plus<<1)
	cbr		merker1,(minus<<1)
	jmp		ber4
ber2:
	cpi		r26,0xff
	brne	ber4
	cpi		r27,0xff
	brne	ber4
	cpi		r28,0xff
	brne	ber4
	cbr		merker1,(plus<<1)
	sbr		merker1,(minus<<1)
	jmp		ber4
ber3:
	sts		anzeigezsp,fz0
	sts		anzeigezsp+1,fz1
	sts		anzeigezsp+2,fz2
ber4:
	sbrc	merker1,(plus)
	jmp		berplus
	sbrc	merker1,(minus)
	jmp		berminus
	ret
berplus:
	ldi		acc,1
	add		fz2,acc
	clr		acc
	adc		fz1,acc
	adc		fz0,acc
	ret
berminus:
	ldi		acc,1
	sub		fz2,acc
	clr		acc
	sbc		fz1,acc
	sbc		fz0,acc
	ret
		
; ----------------------------------------
; Tabellen
; ----------------------------------------

; 6.Stelle  10 00 00H = 1048576
nible6:
.db 0,0,0,0,0,0,0,0 
.db	0,1,0,4,8,5,7,6
.db	0,2,0,9,7,1,5,2
.db	0,3,1,4,5,7,2,8
; 5.Stelle  1 00 00H = 6 55 36
nible5:
.db	0,0,0,0,0,0,0,0
.db	0,0,0,6,5,5,3,6
.db	0,0,1,3,1,0,7,2
.db	0,0,1,9,6,6,0,8
.db	0,0,2,6,2,1,4,4
.db	0,0,3,2,7,6,8,0
.db	0,0,3,9,3,2,1,6
.db	0,0,4,5,8,7,5,2
.db	0,0,5,2,4,2,8,8
.db	0,0,5,8,9,8,2,4
.db	0,0,6,5,5,3,6,0
.db	0,0,7,2,0,8,9,6
.db	0,0,7,8,6,4,3,2
.db	0,0,8,5,1,9,6,8
.db	0,0,9,1,7,5,0,4
.db	0,0,9,8,3,0,4,0
; 4.Stelle  10 00H = 40 98
nible4:
.db 0,0,0,0,0,0,0,0
.db	0,0,0,0,4,0,9,6
.db	0,0,0,0,8,1,9,2
.db	0,0,0,1,2,2,8,8
.db	0,0,0,1,6,3,8,4
.db	0,0,0,2,0,4,8,0
.db	0,0,0,2,4,5,7,6
.db	0,0,0,2,8,6,7,2
.db	0,0,0,3,2,7,6,8
.db	0,0,0,3,6,8,6,4
.db	0,0,0,4,0,9,6,0
.db	0,0,0,4,5,0,5,6
.db	0,0,0,4,9,1,5,2
.db	0,0,0,5,3,2,4,8
.db	0,0,0,5,7,3,4,4
.db	0,0,0,6,1,4,4,0
; 3.Stelle  1 00H = 2 56
nible3:	
.db	0,0,0,0,0,0,0,0
.db	0,0,0,0,0,2,5,6
.db	0,0,0,0,0,5,1,2
.db	0,0,0,0,0,7,6,8
.db	0,0,0,0,1,0,2,4
.db	0,0,0,0,1,2,8,0
.db	0,0,0,0,1,5,3,6
.db	0,0,0,0,1,7,9,2
.db	0,0,0,0,2,0,4,8
.db	0,0,0,0,2,3,0,4
.db	0,0,0,0,2,5,6,0
.db	0,0,0,0,2,8,1,6
.db	0,0,0,0,3,0,7,2
.db	0,0,0,0,3,3,2,8
.db	0,0,0,0,3,5,8,4
.db	0,0,0,0,3,8,4,0
; 2.Stelle  10H = 16
nible2:
.db	0,0,0,0,0,0,0,0
.db	0,0,0,0,0,0,1,6
.db	0,0,0,0,0,0,3,2
.db	0,0,0,0,0,0,4,8
.db	0,0,0,0,0,0,6,4
.db	0,0,0,0,0,0,8,0
.db	0,0,0,0,0,0,9,6
.db	0,0,0,0,0,1,1,2
.db	0,0,0,0,0,1,2,8
.db	0,0,0,0,0,1,4,4
.db	0,0,0,0,0,1,6,0
.db	0,0,0,0,0,1,7,6
.db	0,0,0,0,0,1,9,6
.db	0,0,0,0,0,2,0,8
.db	0,0,0,0,0,2,2,4
.db	0,0,0,0,0,2,4,0
; 1.Stelle  1H = 1
nible1:
.db	0,0,0,0,0,0,0,0
.db	0,0,0,0,0,0,0,1
.db	0,0,0,0,0,0,0,2
.db	0,0,0,0,0,0,0,3
.db	0,0,0,0,0,0,0,4
.db	0,0,0,0,0,0,0,5
.db	0,0,0,0,0,0,0,6
.db	0,0,0,0,0,0,0,7
.db	0,0,0,0,0,0,0,8
.db	0,0,0,0,0,0,0,9
.db	0,0,0,0,0,0,1,0
.db	0,0,0,0,0,0,1,1
.db	0,0,0,0,0,0,1,2
.db	0,0,0,0,0,0,1,3
.db	0,0,0,0,0,0,1,4
.db	0,0,0,0,0,0,1,5

segmente:
.db	0b0011_1111,0		; 0
.db	0b0000_0110,0		; 1
.db	0b0101_1011,0		; 2
.db	0b0100_1111,0		; 3
.db	0b0110_0110,0		; 4
.db	0b0110_1101,0		; 5
.db	0b0111_1101,0		; 6
.db	0b0000_0111,0		; 7
.db	0b0111_1111,0		; 8
.db	0b0110_0111,0		; 9

		
