;	-----------------------------------------
;	CPP9201
;	-----------------------------------------

	.device	ATmega16

	.include	"m16def.inc"
	.include	"allgdef.inc"

	.cseg

	rjmp	restart

	.org	0x08
T1int:
	rjmp	tim2int

	.org	0x10		
T2int:
	rjmp	tim1int

	.org	0x12		
T0int:
	rjmp	tim0int

	.org	0x2a

restart:

;	Stack

	ldi		r16,low(ramend)
	out		spl,r16
	ldi		r16,high(ramend)
	out		sph,r16

;	RAM	lschen

	clr		zh
	ldi		zl,low(ram0)
	ldi		r17,30
	clr		r16
ramclr:
	st		z+,r16
	dec		r17
	brne	ramclr
	
; Timer0
; taktet den Muxer
; Interrupt wird nicht verwendet, der Timer lscht b0 in tifr
; wird im HP abgefragt und mu dann wieder gesetzt werden. 

	ldi		r16,0b00000100		; systemtakt durch 256 = 16us
 	out		tccr0,r16			; ergibt alle 4ms einen MuxTakt

; Timer1
; zhlt die fallende Flanke an Q2 des 74LS161
; zustzlich wird jeder berlauf in der Int von Timer2 gezhlt

	ldi		r16,0b00000110		; fallende Flanke an TB1
	out		tccr1b,r16
	
; Timer2
; erzeugt die Torzeit von 100ms
; takt/64 = 4us, *250 = 1ms, ein zustzlicher Zhler zhlt bis 100ms
; dann wird der Vorzhler (74LS161) gestoppt.

	ldi		r16,0b0000_0100	; Systemtakt durch 64 = 4us
	out		tccr2,r16
	ldi		r16,6			; zhlt aufwrts
	out		tcnt2,r16
	
;	Ports	einstellen

	ldi		r16,0b11111111	; PP-Ausgnge
	out		ddra,r16
	out		porta,r16 		; alle auf H
	
	ldi		r16,0b11110000	; PP-Ausgnge und Eingnge
	out		ddrb,r16		
	ldi		r16,0b00001111	; 4 auf L, und 4x PU
	out		portb,r16
	
	ldi		r16,0b11000011	; PP, In = JTAG, PP
	out		ddrc,r16
	ldi		r16,0b00111100
	out		portc,r16
	
	ldi		r16,0b11111111	; PP-Ausgnge
	out		ddrd,r16
	ldi		r16,0b00000000
	out		portd,r16	

;	Interrupt

	ldi		r16,0b01000100		; nur Timer2
	out		timsk,r16
	sei
	
; 	Anfangswerte

	ldi		acc,8
	sts		dawout,acc
	clr		acc
	sts		dawout+1,acc
	
;	Wachhund

	ldi		acc,0b0000_1000
	out		wdtcr,acc

;--------------------------------------------------
;	HP	*******************************************
;--------------------------------------------------

hp:
	wdr
	call	frequenz
	call	multiplexer
	call	output
	rjmp	hp

;--------------------------------------------------
;	TIM2INT
;--------------------------------------------------

; erzeugt die Torzeit von 100ms
; takt/64 = 4us, *250 = 1ms, ein zustzlicher Zhler zhlt bis 100ms
; dann wird der Vorzhler (74LS161) gestoppt.

tim2int:
	push	acc
	in		accuzsp,sreg
; Torzhler  	
 	inc		torzlr
 	cpi		torzlr,99		; unter 99?
 	brcc	tim2int1		; nein
	ldi		acc,6			; zhlt aufwrts
	out		tcnt2,acc 	
	out		sreg,accuzsp
	pop		acc
	reti
; das letzte mal?
tim2int1:
	cpi		torzlr,100		; unter 100?
	brcc	tim2int2		; nein
	ldi	  	acc,11
	out		tcnt2,acc 	
	out		sreg,accuzsp
	pop		acc
	reti
; fertig, Torzeit vom 100ms ist erreicht!
tim2int2:
	clr		torzlr
	cbi		portb,4			; 74LS161 stopp!
	mov		fz0,ueberfz     ; Zhlwerte kopieren
	clr		ueberfz
	in		fz2,tcnt1l
	in		fz1,tcnt1h
	sbr		merker1,(1<<torende)	; Kennung fertig 
	clr		acc 			; Timer1 lschen
	out		tcnt1h,acc
	out		tcnt1l,acc
	in		fz3,pinb
	in		acc,portb		; 74LS161 Reset
	push	acc
	ori		acc,0b11100000
	out		portb,acc
	pop		acc
	out		portb,acc
	sbi		portb,4			; 74LS161 starten!
	out		sreg,accuzsp
	pop		acc
	reti
	
;--------------------------------------------------
;	TIM1INT
;--------------------------------------------------

; zhlt die fallende Flanke an Q2 des 74LS161
; zustzlich wird jeder berlauf gezhlt

tim1int:
	in		accuzsp,sreg
	inc		ueberfz
	out		sreg,accuzsp
	reti

;--------------------------------------------------
;	TIM0INT
;--------------------------------------------------

; taktet den Muxer
; Interrupt wird nicht verwendet, Polling in der HP-Schleife

tim0int:
;	sbr		merker1,(1<<muxtakt)
	reti

; --------------------------------------------------
	
.include	"frequenz.asm"
.include 	"multiplexer.asm"
.include	"afc.asm"
.include	"div24u.asm"

.exit


