;	-----------------------------------------
;	AVR, Modul fr CPP9201
;	-----------------------------------------
; verwaltet die Automatische Frequenz Nachstimmung
; Eingang: (D)istfrequenz

avr:
	in		acc,pinb
	sbrc	acc,0			; Schalter eingeschaltet?
	jmp		sicherfrequ
; Abweichung ausrechnen
	lds		acc,istfrequenz+2
	lds		zsp,sollfrequenz+2
	sub		acc,zsp
	sts		abweichung+2,acc

	lds		acc,istfrequenz+1
	lds		zsp,sollfrequenz+1
	sbc		acc,zsp
	sts		abweichung+1,acc
	
	lds		acc,istfrequenz
	lds		zsp,sollfrequenz
	sbc		acc,zsp
	sts		abweichung,acc
; Korrektur
	sbrc	acc,7			; negativ?
	jmp		avrneg
	lds		zsp,abweichung+1
	or		acc,zsp
	lds		zsp,abweichung+2
	or		acc,zsp
	brne	avrpos
	ret            			; keine Abweichung
avrneg:
	lds		zl,dawout+1
	lds		zh,dawout
	sbiw	zh:zl,1
	brcc	avrset
	clr		zl
	clr		zh
	jmp		avrset
avrpos:
	lds		zl,dawout+1
	lds		zh,dawout
	adiw	zh:zl,1
	sbrs	zh,4			; berlauf?
	jmp		avrset			; nein
	ldi		zh,0x0f			; ja, auf max begrenzen
	ldi		zl,0xff
; Daten zum DAW
avrset:
	sts		dawout,zh
	sts		dawout+1,zl
	ret
sicherfrequ:
	lds		acc,istfrequenz
	sts		sollfrequenz,acc	
	lds		acc,istfrequenz+1
	sts		sollfrequenz+1,acc	
	lds		acc,istfrequenz+2
	sts		sollfrequenz+2,acc

	ldi		acc,8		 		; auf Mitte setzen
	sts		dawout,acc			; HW
	clr		acc
	sts		dawout+1,acc          ; NW
	ret

; --------------------------------------------------
; OUTPUT
; --------------------------------------------------
; zum DAW ausgeben

output:	
	lds		r26,dawout
	lds		r27,dawout+1
; wegen falscher Reihenfolge der Datenleitungen bits spiegeln
	clr		acc
	clr		zsp
	bst		r26,3
	bld		zsp,0
	bst		r26,2
	bld		zsp,1
	bst		r26,1
	bld		zsp,2
	bst		r26,0
	bld		zsp,3
	bst		r27,7
	bld		zsp,4
	bst		r27,6
	bld		zsp,5
	bst		r27,5
	bld		zsp,6
	bst		r27,4
	bld		zsp,7
	
	bst		r27,3
	bld		acc,0
	bst		r27,2
	bld		acc,1
	bst		r27,1
	bld		acc,6
	bst		r27,0
	bld		acc,7
	
	in		r26,portc
	andi	r26,0b0011_1100
	or		r26,acc
	out		portc,r26
	out     portd,zsp
	ret
	
